PR .= ".mlinux4"
PACKAGES =+ "busybox-ifplugd"
FILESEXTRAPATHS_prepend := ":${THISDIR}/files:"
RDEPENDS_${PN} += "bash"

SRC_URI += "file://udhcpd.conf.example \
            file://ifplugd.action \
            file://ifplugd.default \
            file://ifplugd.init \
            file://eth0.conf \
            file://eth1.conf.example \
            file://ifplugd.patch \
"

do_install_append () {
	install -m 644 ${WORKDIR}/udhcpd.conf.example ${D}${sysconfdir}/udhcpd.conf.example
	install -m 600 ${WORKDIR}/udhcpd.conf.example ${D}${sysconfdir}/udhcpd.conf
        install -d -m 755 ${D}${sysconfdir}/init.d
        install -d -m 755 ${D}${sysconfdir}/ifplugd
        install -d -m 755 ${D}${sysconfdir}/default
        install -m 755 ${WORKDIR}/ifplugd.init ${D}${sysconfdir}/init.d/ifplugd
        install -m 755 ${WORKDIR}/ifplugd.default ${D}${sysconfdir}/default/ifplugd
        install -m 755 ${WORKDIR}/ifplugd.action ${D}${sysconfdir}/ifplugd
        install -m 755 ${WORKDIR}/eth0.conf ${D}${sysconfdir}/ifplugd
        install -m 644 ${WORKDIR}/eth1.conf.example ${D}${sysconfdir}/ifplugd
}

RDEPENDS_${PN}-ifplugd += "bash"
# PACKAGES =+ "${PN}-ifplugd"
inherit update-rc.d
INITSCRIPT_PACKAGES += "${PN}-ifplugd"
INITSCRIPT_NAME_${PN}-ifplugd = "ifplugd"
INITSCRIPT_PARAMS_${PN}-ifplugd = "defaults 3"

FILES_${PN}-ifplugd = "${sysconfdir}/ifplugd/eth0.conf \
               ${sysconfdir}/ifplugd/eth1.conf.example \
               ${sysconfdir}/ifplugd/ifplugd.action \
               ${sysconfdir}/default/ifplugd \
               ${sysconfdir}/init.d/ifplugd \
               "

FILES_${PN}-udhcpc =+ "${sysconfidir}/udhcpd.conf \
                       ${sysconfidir}/udhcpd.conf.example \
                      "


CONFFILES_${PN}-ifplugd = "${sysconfdir}/ifplugd/eth0.conf \
               ${sysconfdir}/ifplugd/ifplugd.action \
               ${sysconfdir}/default/ifplugd \
               ${sysconfidir}/udhcpd.conf \
               "

CONFFILES_${PN}-udhcpc =+ "${sysconfidir}/udhcpd.conf"
